public class Trapezoid {	// Numerical Recipes, p. 137
	public static double trapzd(MathFunction func, double a, double b, int n) {
		if (n==1) {
			s= 0.5*(b-a)*(func.f(a)+func.f(b));
			return s; }
		else {
			int it= 1;						// Addl interior points
			for (int j= 0; j < n-2; j++)
				it *= 2;              		// Subdivisions
				double tnm= it;				// Double value of it
				double delta= (b-a)/tnm;  	// Spacing of points to be added
				double x= a+0.5*delta;		// Point to evaluate f(x)
				double sum= 0.0;			// Contribution of new points x to integral
				for (int j= 0; j < it; j++) {
					sum += func.f(x);
					x+= delta; }
				s= 0.5*(s+(b-a)*sum/tnm);	// Value of integral
				return s;
		}
	}
	private static double s;    // Holds current value of integral. Do only 1 at a time.
}								// "Fake data member"